#include <stdint.h>
#include <graphics.h>
#include <font.h>

#define BITSTREAMVERASANS8_SPACE          3
#define BITSTREAMVERASANS8_FIRST_CHAR     33
#define BITSTREAMVERASANS8_CHARS          94
#define BITSTREAMVERASANS8_HEIGHT         13
#define BITSTREAMVERASANS8_WORDS_PER_LINE 2
#define BITSTREAMVERASANS8_BITS_PER_PIXEL 2

uint16_t bitstreamverasans8_data[BITSTREAMVERASANS8_CHARS][BITSTREAMVERASANS8_WORDS_PER_LINE * BITSTREAMVERASANS8_HEIGHT + 1] =
{
    {  3, 0x0000, 0x0000,  0x0000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x0000, 0x0000,  0x3000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  5, 0x0000, 0x0000,  0x0000, 0x0000,  0x3300, 0x0000,  0x3300, 0x0000,  0x3300, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  9, 0x0000, 0x0000,  0x0000, 0x0000,  0x0082, 0x0000,  0x0085, 0x0000,  0x0FFF, 0xC000,  0x0148, 0x0000,  0x0204, 0x0000,  0x3FFF, 0x0000,  0x0520, 0x0000,  0x0520, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x0300, 0x0000,  0x1FF0, 0x0000,  0x3300, 0x0000,  0x3300, 0x0000,  0x1B80, 0x0000,  0x0370, 0x0000,  0x0330, 0x0000,  0x3FD0, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x0000, 0x0000,},
    { 10, 0x0000, 0x0000,  0x0000, 0x0000,  0x7D08, 0x0000,  0xC324, 0x0000,  0xC320, 0x0000,  0x7D90, 0x0000,  0x019F, 0x4000,  0x0230, 0xC000,  0x0630, 0xC000,  0x081F, 0x4000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    { 10, 0x0000, 0x0000,  0x0000, 0x0000,  0x07D0, 0x0000,  0x0C10, 0x0000,  0x0C00, 0x0000,  0x0A00, 0x0000,  0x1580, 0x8000,  0x3036, 0x4000,  0x241D, 0x0000,  0x0BD2, 0x4000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  3, 0x0000, 0x0000,  0x0000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0000, 0x0000,  0x0800, 0x0000,  0x1400, 0x0000,  0x1000, 0x0000,  0x2000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x2000, 0x0000,  0x1000, 0x0000,  0x1400, 0x0000,  0x0800, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0000, 0x0000,  0x2000, 0x0000,  0x1400, 0x0000,  0x0400, 0x0000,  0x0800, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0800, 0x0000,  0x0400, 0x0000,  0x1400, 0x0000,  0x2000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x0000, 0x0000,  0x0000, 0x0000,  0x0C00, 0x0000,  0x4C40, 0x0000,  0x2E00, 0x0000,  0x2E00, 0x0000,  0x4C40, 0x0000,  0x0C00, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  9, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x00C0, 0x0000,  0x00C0, 0x0000,  0x00C0, 0x0000,  0x3FFF, 0x0000,  0x00C0, 0x0000,  0x00C0, 0x0000,  0x00C0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3F00, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0000, 0x0000,  0x0000, 0x0000,  0x0200, 0x0000,  0x0500, 0x0000,  0x0800, 0x0000,  0x0800, 0x0000,  0x1400, 0x0000,  0x2000, 0x0000,  0x2000, 0x0000,  0x5000, 0x0000,  0x8000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x0B80, 0x0000,  0x1450, 0x0000,  0x2020, 0x0000,  0x3030, 0x0000,  0x3030, 0x0000,  0x2020, 0x0000,  0x1450, 0x0000,  0x0B80, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x3F00, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x3FF0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x1B80, 0x0000,  0x2060, 0x0000,  0x0030, 0x0000,  0x0050, 0x0000,  0x0180, 0x0000,  0x0600, 0x0000,  0x1800, 0x0000,  0x3FF0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x1B90, 0x0000,  0x1030, 0x0000,  0x0020, 0x0000,  0x0FC0, 0x0000,  0x0060, 0x0000,  0x0030, 0x0000,  0x1060, 0x0000,  0x1F80, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x01C0, 0x0000,  0x0240, 0x0000,  0x0880, 0x0000,  0x2080, 0x0000,  0x50C0, 0x0000,  0xFFF0, 0x0000,  0x00C0, 0x0000,  0x00C0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x3FC0, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3F80, 0x0000,  0x0060, 0x0000,  0x0030, 0x0000,  0x0060, 0x0000,  0x3F80, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x07F0, 0x0000,  0x1800, 0x0000,  0x2400, 0x0000,  0x3780, 0x0000,  0x3460, 0x0000,  0x2030, 0x0000,  0x1460, 0x0000,  0x0B80, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x3FF0, 0x0000,  0x0050, 0x0000,  0x0080, 0x0000,  0x0080, 0x0000,  0x0140, 0x0000,  0x0300, 0x0000,  0x0500, 0x0000,  0x0900, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x1B90, 0x0000,  0x3030, 0x0000,  0x2020, 0x0000,  0x0FC0, 0x0000,  0x2460, 0x0000,  0x3030, 0x0000,  0x2460, 0x0000,  0x0B80, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x0B80, 0x0000,  0x2450, 0x0000,  0x3020, 0x0000,  0x2470, 0x0000,  0x0B70, 0x0000,  0x0060, 0x0000,  0x0090, 0x0000,  0x3F40, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  9, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0006, 0x0000,  0x01B4, 0x0000,  0x1E40, 0x0000,  0x1E40, 0x0000,  0x01B4, 0x0000,  0x0006, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  9, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3FFF, 0x0000,  0x0000, 0x0000,  0x3FFF, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  9, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x2400, 0x0000,  0x0790, 0x0000,  0x006D, 0x0000,  0x006D, 0x0000,  0x0790, 0x0000,  0x2400, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x0000, 0x0000,  0x0000, 0x0000,  0x3F40, 0x0000,  0x00C0, 0x0000,  0x0180, 0x0000,  0x0600, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0000, 0x0000,  0x0C00, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    { 12, 0x0000, 0x0000,  0x0000, 0x0000,  0x01BE, 0x4000,  0x0640, 0x6000,  0x1800, 0x1400,  0x2477, 0x0C00,  0x30C3, 0x0C00,  0x30C3, 0x1400,  0x2477, 0x9000,  0x1800, 0x0000,  0x0641, 0x8000,  0x01BE, 0x4000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x0340, 0x0000,  0x0640, 0x0000,  0x0CC0, 0x0000,  0x1890, 0x0000,  0x2460, 0x0000,  0x3FF0, 0x0000,  0x5014, 0x0000,  0x8008, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x3FE4, 0x0000,  0x300C, 0x0000,  0x3008, 0x0000,  0x3FF0, 0x0000,  0x3018, 0x0000,  0x300C, 0x0000,  0x3018, 0x0000,  0x3FE0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x06E4, 0x0000,  0x1804, 0x0000,  0x2400, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x2400, 0x0000,  0x1804, 0x0000,  0x06E4, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x3F90, 0x0000,  0x3024, 0x0000,  0x3008, 0x0000,  0x300C, 0x0000,  0x300C, 0x0000,  0x3008, 0x0000,  0x3024, 0x0000,  0x3F90, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x3FF0, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3FF0, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3FF0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x0000, 0x0000,  0x0000, 0x0000,  0x3FF0, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3FF0, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  9, 0x0000, 0x0000,  0x0000, 0x0000,  0x02F9, 0x0000,  0x1D02, 0x0000,  0x2400, 0x0000,  0x3000, 0x0000,  0x303F, 0x0000,  0x2403, 0x0000,  0x1D03, 0x0000,  0x06F9, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x300C, 0x0000,  0x300C, 0x0000,  0x300C, 0x0000,  0x3FFC, 0x0000,  0x300C, 0x0000,  0x300C, 0x0000,  0x300C, 0x0000,  0x300C, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  3, 0x0000, 0x0000,  0x0000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  3, 0x0000, 0x0000,  0x0000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x6000, 0x0000,  0x8000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x3024, 0x0000,  0x30D0, 0x0000,  0x3340, 0x0000,  0x3D00, 0x0000,  0x3700, 0x0000,  0x31C0, 0x0000,  0x3070, 0x0000,  0x301C, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x0000, 0x0000,  0x0000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3FF0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  9, 0x0000, 0x0000,  0x0000, 0x0000,  0x3407, 0x0000,  0x380B, 0x0000,  0x391B, 0x0000,  0x3223, 0x0000,  0x32A3, 0x0000,  0x30C3, 0x0000,  0x3003, 0x0000,  0x3003, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x380C, 0x0000,  0x380C, 0x0000,  0x360C, 0x0000,  0x320C, 0x0000,  0x308C, 0x0000,  0x309C, 0x0000,  0x302C, 0x0000,  0x302C, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  9, 0x0000, 0x0000,  0x0000, 0x0000,  0x06E4, 0x0000,  0x1809, 0x0000,  0x2406, 0x0000,  0x3003, 0x0000,  0x3003, 0x0000,  0x2406, 0x0000,  0x1809, 0x0000,  0x06E4, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x3F80, 0x0000,  0x3060, 0x0000,  0x3030, 0x0000,  0x3060, 0x0000,  0x3F80, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  9, 0x0000, 0x0000,  0x0000, 0x0000,  0x06E4, 0x0000,  0x1809, 0x0000,  0x2406, 0x0000,  0x3003, 0x0000,  0x3003, 0x0000,  0x2406, 0x0000,  0x1809, 0x0000,  0x06F4, 0x0000,  0x0018, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x3F80, 0x0000,  0x3060, 0x0000,  0x3030, 0x0000,  0x3060, 0x0000,  0x3F80, 0x0000,  0x3090, 0x0000,  0x3020, 0x0000,  0x3018, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x0BE4, 0x0000,  0x2408, 0x0000,  0x3000, 0x0000,  0x1E50, 0x0000,  0x0064, 0x0000,  0x000C, 0x0000,  0x2018, 0x0000,  0x1BE0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0xFFFC, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x300C, 0x0000,  0x300C, 0x0000,  0x300C, 0x0000,  0x300C, 0x0000,  0x300C, 0x0000,  0x300C, 0x0000,  0x2418, 0x0000,  0x0BE0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x8008, 0x0000,  0x5014, 0x0000,  0x2020, 0x0000,  0x2460, 0x0000,  0x0880, 0x0000,  0x0880, 0x0000,  0x0740, 0x0000,  0x0200, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  9, 0x0000, 0x0000,  0x0000, 0x0000,  0x8080, 0x8000,  0x50C1, 0x4000,  0x51D1, 0x4000,  0x2162, 0x0000,  0x2222, 0x0000,  0x1625, 0x0000,  0x191D, 0x0000,  0x0C0C, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x5014, 0x0000,  0x2420, 0x0000,  0x0880, 0x0000,  0x0300, 0x0000,  0x0740, 0x0000,  0x0880, 0x0000,  0x2020, 0x0000,  0x5014, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x5014, 0x0000,  0x2020, 0x0000,  0x0880, 0x0000,  0x0740, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  9, 0x0000, 0x0000,  0x0000, 0x0000,  0x3FFF, 0x0000,  0x0008, 0x0000,  0x0024, 0x0000,  0x0050, 0x0000,  0x0140, 0x0000,  0x0600, 0x0000,  0x0800, 0x0000,  0x3FFF, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0000, 0x0000,  0x0000, 0x0000,  0x3C00, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3C00, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0000, 0x0000,  0x0000, 0x0000,  0x8000, 0x0000,  0x5000, 0x0000,  0x2000, 0x0000,  0x2000, 0x0000,  0x1400, 0x0000,  0x0800, 0x0000,  0x0800, 0x0000,  0x0500, 0x0000,  0x0200, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0000, 0x0000,  0x0000, 0x0000,  0x3C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x3C00, 0x0000,  0x0000, 0x0000,},
    {  9, 0x0000, 0x0000,  0x0000, 0x0000,  0x01D0, 0x0000,  0x0624, 0x0000,  0x1405, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0xFFF0, 0x0000,},
    {  6, 0x0000, 0x0000,  0x5000, 0x0000,  0x1400, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0FD0, 0x0000,  0x0020, 0x0000,  0x1BF0, 0x0000,  0x3030, 0x0000,  0x3070, 0x0000,  0x1F70, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3780, 0x0000,  0x3460, 0x0000,  0x3030, 0x0000,  0x3030, 0x0000,  0x3460, 0x0000,  0x3780, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0BC0, 0x0000,  0x2400, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x2400, 0x0000,  0x0BC0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0030, 0x0000,  0x0030, 0x0000,  0x0030, 0x0000,  0x0B70, 0x0000,  0x2470, 0x0000,  0x3030, 0x0000,  0x3030, 0x0000,  0x2470, 0x0000,  0x0B70, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0B80, 0x0000,  0x2420, 0x0000,  0x3FF0, 0x0000,  0x3000, 0x0000,  0x2420, 0x0000,  0x0B90, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0000, 0x0000,  0x1F00, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0xFF00, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0B70, 0x0000,  0x2470, 0x0000,  0x3030, 0x0000,  0x3030, 0x0000,  0x2470, 0x0000,  0x0B70, 0x0000,  0x0060, 0x0000,  0x0F80, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x37D0, 0x0000,  0x3460, 0x0000,  0x3030, 0x0000,  0x3030, 0x0000,  0x3030, 0x0000,  0x3030, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  3, 0x0000, 0x0000,  0x0000, 0x0000,  0x3000, 0x0000,  0x0000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  3, 0x0000, 0x0000,  0x0000, 0x0000,  0x3000, 0x0000,  0x0000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0xD000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x0000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3090, 0x0000,  0x3240, 0x0000,  0x3D00, 0x0000,  0x3700, 0x0000,  0x31C0, 0x0000,  0x3070, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  3, 0x0000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    { 11, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x37D7, 0xD000,  0x3474, 0x6000,  0x3030, 0x3000,  0x3030, 0x3000,  0x3030, 0x3000,  0x3030, 0x3000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x37D0, 0x0000,  0x3460, 0x0000,  0x3030, 0x0000,  0x3030, 0x0000,  0x3030, 0x0000,  0x3030, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0B80, 0x0000,  0x2460, 0x0000,  0x3030, 0x0000,  0x3030, 0x0000,  0x2460, 0x0000,  0x0B80, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3780, 0x0000,  0x3460, 0x0000,  0x3030, 0x0000,  0x3030, 0x0000,  0x3460, 0x0000,  0x3780, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0B70, 0x0000,  0x2470, 0x0000,  0x3030, 0x0000,  0x3030, 0x0000,  0x2470, 0x0000,  0x0B70, 0x0000,  0x0030, 0x0000,  0x0030, 0x0000,  0x0000, 0x0000,},
    {  5, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x37C0, 0x0000,  0x3400, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x1B90, 0x0000,  0x3010, 0x0000,  0x1940, 0x0000,  0x01A0, 0x0000,  0x1030, 0x0000,  0x1B90, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0000, 0x0000,  0x0000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0xFF00, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x1F00, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3030, 0x0000,  0x3030, 0x0000,  0x3030, 0x0000,  0x3030, 0x0000,  0x2470, 0x0000,  0x1F70, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0xC030, 0x0000,  0x5050, 0x0000,  0x2080, 0x0000,  0x2580, 0x0000,  0x1A40, 0x0000,  0x0A00, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  9, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x20C2, 0x0000,  0x31D3, 0x0000,  0x2262, 0x0000,  0x1625, 0x0000,  0x1D1D, 0x0000,  0x0C0C, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x5050, 0x0000,  0x2080, 0x0000,  0x0A00, 0x0000,  0x0A00, 0x0000,  0x2580, 0x0000,  0x5050, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x8020, 0x0000,  0x9050, 0x0000,  0x2080, 0x0000,  0x2540, 0x0000,  0x0A00, 0x0000,  0x0A00, 0x0000,  0x0800, 0x0000,  0xF400, 0x0000,  0x0000, 0x0000,},
    {  5, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0xFFC0, 0x0000,  0x0140, 0x0000,  0x0600, 0x0000,  0x1800, 0x0000,  0x6000, 0x0000,  0xFFC0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x01F0, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x3D00, 0x0000,  0x0700, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x01F0, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0000, 0x0000,  0x0000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x3D00, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x01F0, 0x0000,  0x0340, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x3D00, 0x0000,  0x0000, 0x0000,},
    {  9, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x1F41, 0x0000,  0x107D, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,}
};

const font_t bitstreamverasans8 = {BITSTREAMVERASANS8_BITS_PER_PIXEL, BITSTREAMVERASANS8_WORDS_PER_LINE, BITSTREAMVERASANS8_HEIGHT, BITSTREAMVERASANS8_HEIGHT - (BITSTREAMVERASANS8_HEIGHT >> 2), BITSTREAMVERASANS8_FIRST_CHAR, BITSTREAMVERASANS8_CHARS, BITSTREAMVERASANS8_SPACE, bitstreamverasans8_data[0] };

